if (typeof browser == "undefined")
  var browser = chrome;

var _supportsPromises = false;
try {
  _supportsPromises = browser.runtime.getPlatformInfo() instanceof Promise;
}
catch (e)
{
}

browser.runtime.onMessage.addListener(function(request, sender, sendResponse) {
	RevEx.BrowserOverlay.execute();
});

RevEx.BrowserOverlay =
{
	pageLoad : function()
	{
		var documentDOMNode = window.document;

		RevEx.BrowserOverlay.createPage(documentDOMNode);

		var view = documentDOMNode.defaultView;
		view.addEventListener("unload", RevEx.BrowserOverlay.pageUnload, true);
	},

	pageUnload : function(event)
	{
		var documentDOMNode = event.originalTarget;

		RevEx.BrowserOverlay.removePage(documentDOMNode);
	},

	pages : new RevEx.util.Hashtable(),
	getPage : function(pageId)
	{
		if (RevEx.BrowserOverlay.pages.containsKey(pageId))
			return RevEx.BrowserOverlay.pages.get(pageId);
		return null;
	},
	createPage : function(pageId)
	{
		var page = null;
		if (RevEx.BrowserOverlay.pages.containsKey(pageId))
			page = RevEx.BrowserOverlay.pages.get(pageId);
		else
		{
			page = new RevEx.ReviewExtractor(pageId);
			RevEx.BrowserOverlay.pages.put(pageId, page);
		}

		return page;
	},
	removePage : function(pageId)
	{
		if (RevEx.BrowserOverlay.pages.containsKey(pageId))
			RevEx.BrowserOverlay.pages.remove(pageId);
	},

	execute : function()
	{
		console.log("Executing");
		RevEx.BrowserOverlay.pageLoad();

		var documentDOMNode = window.document;
		var reviewExtractor = RevEx.BrowserOverlay.getPage(documentDOMNode);
		if (reviewExtractor == null)
			return;

		var reviewExtracted = reviewExtractor.reviewExtracted;

		if (!reviewExtracted) {
			RevEx.BrowserOverlay.showProcessingMessage(reviewExtractor);
		}
		else {
			RevEx.BrowserOverlay.toggleView(reviewExtractor);
		}
	},

	extraction : function(reviewExtractor)
	{
		var reviewExtracted = reviewExtractor.reviewExtracted;
		if (!reviewExtracted)
			RevEx.BrowserOverlay.extractContent(reviewExtractor);
		else
			RevEx.BrowserOverlay.toggleView(menuExtractor);
	},
	
	extractContent : function(reviewExtractor)
	{
		var initialURL = window.location.href;
		if (initialURL.search("about:") == -1){
			reviewExtractor.extractContent(initialURL, RevEx.BrowserOverlay.reviewExtracted.bind(null, reviewExtractor));
		}
		else {
			alert("Not a webpage");
			return;
		}
	},

	reviewExtracted : function(reviewExtractor)
	{
		browser.runtime.sendMessage({content: "clear"});
		RevEx.BrowserOverlay.toggleView(reviewExtractor);
	},

	showProcessingMessage : function(reviewExtractor)
	{
		browser.runtime.sendMessage({content: "message"});

		setTimeout(function() {
			RevEx.BrowserOverlay.extraction(reviewExtractor);
		}, 350);
	},

	toggleView : function(reviewExtractor)
	{
		reviewExtractor.toggleView(RevEx.BrowserOverlay.toggledView)
	},

	toggledView : function()
	{	
		browser.runtime.sendMessage({content: "endExtraction"});
	}
};
