RevEx.revex.Content = function(body, website)
{
	this.depth = 0;
	this.forbiddenNodes = new Array("LABEL","INPUT","FORM","OPTION","BUTTON","SVG");

	this.threshold = 0;	
	this.posi = -1;
	this.oc = new RevEx.util.Hashtable();
	this.maxCluster = 0;	
	this.clusters = new Array();
	this.maxlevel = 0;
	this.differentGroups = new Array();
	this.finalValor = 0;
	this.cList = new Array();
	this.maxNode = document.createElement("null"); 
	
	this.processContent = function(body)
	{	
		this.preprocess(body);
		this.posNode(body, 0);
		this.numberNode(body, 0);

		this.rateNode(body);
		
		this.computeMatrix(body);
		this.removeLower(RevEx.revex.Config.removeLower);
		//this.showGroups();
		this.markTree(body);
		this.computeRoots(body);

		this.threshold = body.textContent.replace(/\s/g,'').length;
		this.assignValue(body);
		this.computeMax(body);		
		this.marcaHTML(body);
		this.marcaHTMLPosibles(body);
		return body;
	}
	
	this.markTree = function(node)
	{
		if (node && node.nodeType == 1){
			var ocurrenceEntries = this.oc.entries();
			for (var i = 0; i < ocurrenceEntries.length; i++){
				var vec = ocurrenceEntries[i];			
				if (vec[0] == node.posi){
					node.group = vec[1][1];
					console.log("ocurrencia: " + vec[1][1]);	
				}
			}		
		}
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.markTree(children[i]);
			}
		}
	}
	
	this.checkDescendantGroup = function(node,group)
	{
		let count = 0;
		if (node && node.nodeType == 1)
			if (node.group == group)
				count++;

		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				count += this.checkDescendantGroup(children[i],group);
			}
		}
		return count;
	}
	this.hasText = function(node)
	{
		var nodeName = node.nodeName.toLowerCase();
		if (nodeName != "#text")
			return false;

		var nodeText = node.nodeValue;
		return (nodeText != "");
	}	
	this.isHidden = function(node)
	{
		if (node.nodeType == 1){
			let condition = false;
			if (node.style)
				if (node.style.visibility === "hidden" || node.style.display === "none")
					condition = true;
			if (node.isHidden)
				condition = true;
				
			return condition;
		}
		else
			return !this.hasText(node);
	}
	
	this.isHidden2 = function(node)
	{
		while (node.tagName != "BODY"){
			if (!this.isHidden(node)){
				node = node.parentNode;
			}
			else
				return true;
		}
		return false;
	}

	this.assignValue = function(node)
	{
		if (node && node.clus && !this.isHidden2(node)){
			let nodes = this.countDescendants(node,true);
			let thresh = Math.sqrt(this.threshold / node.textContent.replace(/\s/g,'').length);
			let imag = this.linkWithImage(node)+1;
			let forbid = this.countForbidden(node,true)+1;
			if (imag == 0)
				imag = 1;

			let words = this.countTextNotLink(node, node, true)
			this.differentGroups = [];
			let groups = this.countGroups(node);
			let lev = node.depth;
			let links = this.countLinks(node);

			let valor = words * groups * lev * node.posi / imag;

			node.finalval = valor;
		}
			
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.assignValue(children[i]);
			}
		}
	}		

	this.countGroups = function(node)
	{
		if (node && node.group){
			if (!this.differentGroups.includes(node.group))
				this.differentGroups.push(node.group);
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.countGroups(children[i]);
			}
		}
		return this.differentGroups.length;
	}	

	this.computeMax = function(node)
	{
		if (node && node.finalval){
			if ((node.finalval) > this.finalValor)
				this.finalValor = (node.finalval);
		}
		
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.computeMax(children[i]);
			}
		}
	}	
	
	this.marcaHTML = function(node)
	{
		if (node && node.clus)
			if ((node.finalval) == this.finalValor){
					node.final = 1;
					this.maxNode = node;
					this.cList = node.classList;
					return;
			}else{
				node.final = 0;
			}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.marcaHTML(children[i]);
			}
		}
	}
	
	this.findValueInClustersArray = function(value)
	{
		var result;
		for( var i = 0, len = this.clusters.length; i < len; i++ ) {
			if( this.clusters[i][0] === value ) {
				result = this.clusters[i][1];
				break;
			}
		}	
		return result;		
	}
	
	this.computeRoots = function(node)
	{
		let node2 = node;
		if (node2 && node2.nodeType == 1){
			if (node2.group){
				let group = node2.group;
				let val = this.findValueInClustersArray(group);
				if (val > 0){
					node2 = node2.parentNode;
					//node2.clus = group;
					while((this.checkDescendantGroup(node2,group) < (val-1)) && node2.tagName != "BODY")
						node2 = node2.parentNode;

					if (this.checkDescendantGroup(node2,group) >= (val-1) && node2.tagName != "BODY"){
						node2.clus = group;
						console.log("clus: " + node2.clus);
					}					
				}
			}
		}
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.computeRoots(children[i]);
			}
		}
	}		
	
	this.checkClassName = function(n1)
	{
		let iguales = true;
		let classNameA = n1.className+" ";
		
		if (n1){
			let n2 = n1.parentNode;
			let children = new Array();
			if (n2 && n2.nodeType == 1)
				children = n2.childNodes;
				
			if (this.returnChildrenNotUndefined(n2) > 1){
				for (var i = 0; i < children.length; i++){
					if (children[i].tagName != undefined){
						let classNameB = children[i].className+" ";
						if (!classNameB.includes("undefined") ){
							if(classNameA != classNameB){
								iguales = false;
							}
						}
					}
				}
			}
			else
				return false;
		}
		else
			return false;

		return iguales;
	}
	
	this.checkEqualClassName = function(n1)
	{
		let iguales = false;
		let total = 0;
		//let equal = 0;
		let classes = new Array();
		
		let children = n1.childNodes;
		for (var i = 0; i < children.length; i++){
			if (children[i].tagName != undefined){
				total++;
				let className = children[i].className+" ";
//				if (classes.length == 0)
					classes.push(className);
//				if (classes.includes(className))
//					equal++;
			}
		}
		
		let equal = this.numberRepeatedClasses(classes);
		
		if ((equal*2 > total) && (total > 1))
			iguales = true;
		
		return iguales;
	}
	
	this.numberRepeatedClasses = function(array)
	{
		if(array.length == 0)
			return null;
		var modeMap = {};
		var maxEl = array[0], maxCount = 1;
		for(var i = 0; i < array.length; i++)
		{
			var el = array[i];
			if(modeMap[el] == null)
				modeMap[el] = 1;
			else
				modeMap[el]++;  
			if(modeMap[el] > maxCount)
			{
				maxEl = el;
				maxCount = modeMap[el];
			}
		}
		return maxCount;
	}	
	
	this.returnChildrenNotUndefined = function(node)
	{
		let number = 0;
		let children = new Array();
		if (node && node.nodeType == 1)
			children = node.childNodes;		

		for (var i = 0; i < children.length; i++){
			if (children[i].tagName != undefined)
				number++;				
		}
		return number;
	}
	
	this.showGroups = function(){
		let count2 = 0;
		for(let j=0; j<=this.maxCluster; j++){
			count = 0;
			var ocurrenceEntries = this.oc.entries();
			for (var i = 0; i < ocurrenceEntries.length; i++){
				var vec = ocurrenceEntries[i];			
				if (vec[1][1] == j)
					count++;
			}
			console.log(j + "<->" + count);
			count2 = count2+count;
		}	
	}
	
	this.removeLower = function(thres){
		for(let j=0; j<=this.maxCluster; j++){
			count = 0;
			var ocurrenceEntries = this.oc.entries();
			for (var i = 0; i < ocurrenceEntries.length; i++){
				var vec = ocurrenceEntries[i];			
				if (vec[1][1] == j)
					count++;
			}
			console.log(j + "<->" + count);
			if (count < thres){
				for (var i = 0; i < ocurrenceEntries.length; i++){
					var vec = ocurrenceEntries[i];			
					if (vec[1][1] == j)
						var ocurrence = this.oc.remove(vec[0]);
				}
			}else{
				let ar = [j,count];
				this.clusters.push(ar);
			}
		}
	}

	this.linkWithImage = function(node)
	{
		var count = 0;
		if ((node.tagName == "IMG" || node.tagName == "SVG") && this.checkAncestors(node,RevEx.revex.Config.checkAncestorsMaxLevel)){
			count++;
		}
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				count += this.linkWithImage(children[i]);
			}
		}
		return count;
	}
	
	this.checkAncestors = function(node,maxLevel)
	{
		let level = 1;
		while (node.parentNode != null && level <= maxLevel){
			node = node.parentNode;
			level++;
			if (node.tagName == "A")
				return true;
		}
		return false;
	}
	
	this.countLinks = function(node)
	{
		var count = 0;
		if (node.tagName == "A"){
			count++;
		}
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				count += this.countLinks(children[i]);
			}
		}
		return count;
	}		

	this.posNode = function(node, depth)
	{
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			depth++;
			for (var i = 0; i < children.length; i++){  
				if(children[i].nodeType != 3){
					children[i].depth = depth;
					if (this.depth < depth)
						this.depth = depth;
					this.posNode(children[i], depth);
				}
			}
		}
	}
	
	this.depthNode = function(node)
	{
		let depth = 0;
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			depth++;
			for (var i = 0; i < children.length; i++)
				this.depthNode(children[i]);
		}
		return depth;
	}	
	
	this.numberNode = function(node, number)
	{
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){  
				if(children[i].nodeType != 3){
					children[i].number = number;
					number++;
					this.numberNode(children[i], number);
				}
			}
		}
	}

	this.wordCount = function(str) { 
	  return str.split(" ").length;
	}	
	
	this.countWords = function(node, getChildrensChildren, origNode)
	{
		var counter = 0;
		var cadena = "";
		
		if ((node.nodeType == 3) && (node.parentNode.tagName != "A")){
			cadena = node.textContent.trim();
			var dist = this.distanceBetweenTwoNodes(node, origNode);
			counter = counter + (this.wordCount(cadena)/dist);
			cadena = "";
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes.length;
			for(var i=0; i < children; i++){
				if(getChildrensChildren)
					counter += this.countWords(node.childNodes[i],true, origNode);
			}
		}

		return counter;
	}
	
	this.distanceBetweenTwoNodes = function(node1,node2){
		var distance = 0;
		while (node1 != node2){
			node1 = node1.parentNode;
			distance++;
		}
		return distance;
	}
	
	this.rateNode = function(node)
	{
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			if ((children.length >= 1) && (node.textContent.replace(/\s/g,'').length > this.threshold))
					if ((node.nodeType != 3) && (node.display !== 'none') && (node.style.visibility !== 'hidden')){
						this.maxlevel = 0;
						this.countLevel(node);
						console.log("level: " + (this.maxlevel-node.depth));
						if ((this.maxlevel-node.depth) >= RevEx.revex.Config.maxRatingLevel){
							node.ratio = this.computeNodeRatio(node);
							this.posi++;
							node.posi = this.posi;
						}
					}
		}
		if (node && node.childNodes.length > 0){
			var children = node.childNodes.length;
				for (var i = 0; i < children; i++)
						this.rateNode(node.childNodes[i]);
		}
	}
	
	this.countTerminals = function(node, getChildrensChildren, origNode)
	{
		var counter = 0;
		
		if (node.nodeType == 3){
			counter++;
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes.length;
			for(var i=0; i < children; i++){
				if(getChildrensChildren)
					counter += this.countTerminals(node.childNodes[i],true, origNode);
			}
		}
		return counter;
	}
	
	this.countDescendants = function(node, getChildrensChildren)
	{
		var counter = 0;
		
		if (node){
			counter++;
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes.length;
			for(var i=0; i < children; i++){
				if(getChildrensChildren)
					counter += this.countDescendants(node.childNodes[i],true);
			}
		}
		return counter;
	}	
	
	this.countLevel = function(node)
	{
		if (node && node.depth > this.maxlevel){
			this.maxlevel = node.depth;
		}
		
		if (node.childNodes.length > 0){
			for(var i=0; i < node.childNodes.length; i++)
				this.countLevel(node.childNodes[i]);

		}
	}		
	
	this.computeNodeRatio = function(node){
		var ratio = new Array();
		var contentProbability = 0;
		var nodos = node.getElementsByTagName("*").length;
		
		var terms = this.countTerminals(node, true, node);

		var countWords = this.countWords(node, true, node);
		
		var brothersProbability = node.childNodes.length;
		
		var descendants = this.countDescendants(node, true);

		var depthProbability = node.depth;
		
		ratio[0] = terms;
		ratio[1] = descendants;
		ratio[2] = brothersProbability;
		ratio[3] = depthProbability;
		
		return ratio;
	}

	this.preprocess = function(node)
	{
		let nodo = document.createElement('div');
		if (node.tagName == "SCRIPT" || node.tagName == "STYLE" || node.nodeType == 8 || node.nodeType == 4 || node.tagName == "NOSCRIPT" || node.tagName == "TABLE" || node.tagName == "FORM"  || node.tagName == "FOOTER"  || node.tagName == "HEADER"  || node.tagName == "SELECT"  || node.tagName == "INPUT"  || node.tagName == "BUTTON"){
			if (node.parentNode)
				node.parentNode.replaceChild(nodo, node);
		}
		if (node.nodeType == 1){
			let ident = " ";
			if (node.id)
				ident = ident + node.id;
			if ((ident.search(/cookie/i) != -1) || (node.classList.contains("cookie"))){
			if (node.parentNode)
				node.parentNode.replaceChild(nodo, node);	
			}
		}
		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.preprocess(children[i]);
			}
		}
	}

	this.countTextNotLink = function(node, node2, getChildrensChildren)
	{
		var counter = 0;
		var cadena = "";
		
		if (node.nodeType == 3 && !this.isHidden2(node) && node.parentNode.tagName != "A"){
			cadena = node.nodeValue.replace(/\s/g, "");
			let dist = this.distanceBetweenTwoNodes(node,node2);
			counter = counter + (cadena.length/dist);
			cadena = "";
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes.length;
			for(var i=0; i < children; i++){
				if(node.childNodes[i].tagName != "A" && !this.isHidden2(node.childNodes[i])){
					if(getChildrensChildren)
						counter += this.countTextNotLink(node.childNodes[i],node2,true);
				}
			}
		}

		return counter;
	}

	this.computeMatrix = function (node1)
	{
		if (node1.ratio) 
			this.computeCentroid(node1, body);
		
		var children = node1.childNodes;
		for (var i = 0; i < children.length; i++){  
			if(children[i].ratio){
				this.maxCluster++;
				this.computeMatrix(children[i]);
			}
		}		
		
	}
	this.computeCentroid = function(node1, node2)
	{
		if (node1.ratio && node2.ratio){

			if (node1.ratio[0] == node2.ratio[0] && node1.ratio[1] == node2.ratio[1] && node1.ratio[2] == node2.ratio[2] && node1.ratio[3] == node2.ratio[3]){

				var ocurrence = this.oc.remove(node1.posi);	
				var ocur = new Array();
				ocur.push(node1, this.maxCluster);
				this.oc.put(node1.posi, ocur);				

				var ocurrence = this.oc.remove(node2.posi);	
				var ocur = new Array();
				ocur.push(node2, this.maxCluster);
				this.oc.put(node2.posi, ocur);	
			}
		}

		var children = node2.childNodes;
		for (var i = 0; i < children.length; i++){
			if(children[i].ratio){
				this.computeCentroid(node1, children[i]);
			}
		}
	}
	this.countForbidden = function(node, getChildrensChildren)
	{
		var counter = 0;
		
		if (this.forbiddenNodes.includes(node.tagName)){
			counter++;
		}

			var children = node.childNodes.length;
			for(var i=0; i < children; i++){
				if(getChildrensChildren)
					counter += this.countForbidden(node.childNodes[i],true);
			}

		return counter;
	}	

	this.marcaHTMLPosibles = function(node)
	{
		if (node){
			if (node.finalval < this.finalValor && node.final == 0 && this.cList.length >= 3){
				let cont = 0;
				for(let i = 0; i < this.cList.length; i++)
				{
					if (node.classList.contains(this.cList[i]))
						cont++;
				}
				if (cont >= (this.cList.length / 2)){
					this.maxNode.final = 0;
					let a = this.getCommonAncestor(this.maxNode, node);
					a.final = 1;
					//node.final = 1;
				}
			}
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.marcaHTMLPosibles(children[i]);
			}
		}
	}
	
	this.getCommonAncestor = function (nodo1, nodo2) {
		while (nodo1 = nodo1.parentElement) {
			if (nodo1.contains(nodo2)) {
				return nodo1;
			}
		}
		return null;
	}
	
	return this.processContent(body);
}