RevEx.ReviewExtractor = function(document)
{
	/******************************************************/
	/************************ Info ************************/
	/******************************************************/

	this.reviewExtracted = false;
	this.showingContent = false;
	this.document = document;
	this.originalBody = this.document.body;
	this.contentBody = null;

	this.obtainAlgorithm = function()
	{
		return new RevEx.revex.RevEx();			
	}

	/******************************************************/
	/****************** Extract Content ******************/
	/******************************************************/
	this.extractContentCallback = null;

	this.extractContent = function(initialURL, callback)
	{
		this.extractContentCallback = callback;

		if (this.reviewExtracted)
		{
			this.extractContentCallback();
			return;
		}

		this.extractWebContent(initialURL);
	}
	this.extractWebContent = function(initialURL)
	{
		var algorithm = this.obtainAlgorithm();

		algorithm.process(initialURL, this.document, this.extractedWebContent.bind(this));
	}
	this.extractedWebContent = function(contentBody, contentNodes)
	{
		this.posHide(contentNodes);
		this.contentBody = contentNodes;
		this.reviewExtracted = true;
		this.extractContentCallback();
	}

	/******************************************************/
	/******************** Toogle view *********************/
	/******************************************************/
	this.toggleViewCallback = null;

	this.toggleView = function(callback)
	{
		this.toggleViewCallback = callback;

		if (!this.reviewExtracted)
		{
			this.toggleViewCallback();
			return;
		}

		this.toggleTheView();
	}
	this.toggleTheView = function()
	{
		if (!this.showingContent){
			this.document.body = this.contentBody;
		}
		else
			this.document.body = this.originalBody;
		this.finishToggleView();
	}
	this.finishToggleView = function()
	{
		this.showingContent = this.document.body == this.contentBody;
		this.toggleViewCallback();
	}

	/******************************************************/
	/*********************** Others ***********************/
	/******************************************************/ 
	this.hideNotContentNodes = function(contentBody, contentNodes)
	{
		var contentNode;
		var treeSearch = new RevEx.util.TreeSearch(contentBody, new Array());

		while ((contentNode = treeSearch.nextPreOrder()) != null)
			if (!RevEx.misc.Misc.arrayContains(contentNodes, contentNode))
				this.hideNode(contentNode);
	}

	this.posHide = function(node)
	{
		if ((node.final == 1)){
			console.log(node.outerHTML);
			this.hideStuff(node);
			return 0;
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				this.posHide(children[i]);
			}
		}		
	}	
	
	this.hideStuff = function(el){
	  var node, nodes = [];
	  
	  do {
		var parent = el.parentNode;
		
		if (parent)
			iLen=parent.childNodes.length
		else
			iLen = 0;
		
		for (var i=0; i<iLen; i++) {
		  node = parent.childNodes[i];

		  if (node.nodeType == 1 && node != el) {
			nodes.push(node);
		  }
		}

		el = parent;

	  } while (el && el.nodeType == 1 && el.tagName.toLowerCase() != 'body');

	  nodes.forEach(function(node){
		if (RevEx.revex.Config.showOriginalLayout == true)
			node.style.visibility = "hidden";
		else
			node.style.display = "none";
		hideChildren(node);			
	  });
	}
	
	this.hideNode = function(node)
	{
		node.isHidden = true;

		if (node.style)
		{
			node.style.visibility = "hidden";
			return;
		}

		var nodeName = node.nodeName.toLowerCase();
		if (nodeName == "#text")
			node.nodeValue = "";
	}
	
	function hideChildren(node)
	{
		if (node.nodeType == 1){
			if (node.style){
				if (RevEx.revex.Config.showOriginalLayout == true)
					node.style.visibility = "hidden";
				else
					node.style.display = "none";				
			}
		}

		if (node && node.childNodes.length > 0){
			var children = node.childNodes;
			for (var i = 0; i < children.length; i++){
				hideChildren(children[i]);
			}
		}		
	}		

}
